! Tasks.h 
!					by Eric Eve 17-APR-04
!		 This file provides a slightly more user-friendly (or programmer-friendly)
!		 way of handling the task-based scoring system. Instead of having to keep
!		 track of which number has been assigned to a task, and counting along a
!		 byte array to insert the appropriate score, you can now define your tasks
!		 as a series of objects and allow the InitTasks routine to initialize the
!		 scores array for you. There is also no need to provide your own PrintTaskName routine
!		 since one is provided in this header file. Finally, the new routine achieve(task_name)
!		 can be used instead of the old achieved(task_number), so you don't have to keep
!		 track of the task numbers in your code (and can insert new tasks in the sequence as
!		 desired without having to worry about renumbering).
!
!		 N.B. This is not a replacement for the existing task-based scoring system,
!		 it is just a friendlier front end to it.
!
!
!
! USAGE: Include "Tasks" after Include "Parser" but before
!		 CONSTANT MAX_SCORE or CONSTANT NUMBER_TASKS;
!
!		 This file defaults to a MAX_SCORE of 0
!		 And 40 tasks. You can changes these by adding
!		 your own definitions of CONSTANT MAX_SCORE and CONSTANT NUMBER_TASKS
!		 BEFORE you include this file.
!
!		 In your own code create a Tasks object, then list all your tasks as children
!		 of this Tasks object, making them of class ATask. The name of the task should
!		 be the task description you want displayed in response to the FULLSCORE command;
!		 if you want the score associated with the task to be anything but 1 then you
!		 need to add "with value n" to the definition of the task in question;
!
!		 e.g.
!
!		 Object Tasks;
!		 ATask -> finding_key "Finding the key";
!		 ATask -> killing_villain "Killing the villain" with value 10;
!
!		 To register a task as achieved in your code use achieve(task_name) rather than
!		 the standard achieved(task_number);
!		 NOTE the dropping of the final D from ACHIEVE
!		 e.g. achieve(finding_key);
!
!		 When run in DEBUG mode InitTasks warns you if the value of MAX_SCORE is different
!		 from the total of the individual scores for all the tasks, and suggests that you may
!	     want to change MAX_SCORES; this may or may not be an appropriate action, depending
!		 on the details of your game. For example, if you want to attach scores to mutually
!		 exclusive courses of action, or if you want it to be possible to own bonus scores
!		 for some tasks.
!		 
!
!
!		 Finally, make sure your Initialize routine calls InitTasks();
!		 
!		 Note that this header file contains its own definitions of the
!		 task_scores array and the PrintTaskName routine; these should not appear
!		 in your own code.
!
!		 Moving tasks (or other objects) to and from the Tasks object in your own code
!		 is inadvisable and may lead to unpredictable results. If for any reason you
!		 do need to do this, you MUST then call the InitTasks routine again.
!
!		 If compiles in DEBUG mode, InitTasks prints useful debugging information
!		 
!		 If NUMBER_TASKS is too small for the number of tasks you have defined (it defaults
!		 to 40) only the first NUMBER_TASKS tasks will be properly initialized and 
!		 InitTasks will print a warning suggesting you increase the size of NUMBER_TASKS
!
!		 If your program defines the constant VERIFY_TASKS further debugging information
!	     (the total number of tasks defined and the total score they would generate)
!		 which you may want to use to adjust the NUMBER_TASKS and MAX_SCORE constants
!		 in your own code.



system_file;

Message "Compiling Tasks.h";

#ifndef TASKS_PROVIDED;
    Constant TASKS_PROVIDED;
#endif;    
    
#ifndef NUMBER_TASKS;   
   Constant NUMBER_TASKS 40;
#endif;

#ifndef MAX_SCORE;
  Constant MAX_SCORE 0;
#endif;
   
Array task_scores -> NUMBER_TASKS;

Class ATask 
  with value 1, number 0;



[ InitTasks t n total;
  objectloop(t in tasks){
    t.number=n;
    if (n<NUMBER_TASKS) task_scores->n = t.value;
      total=total+t.value;
    n++;    
    }
  
  #ifdef DEBUG;
   #ifdef VERIFY_TASKS;
     print "Task Array initialized; ", n, " tasks found: total score available = ",total,"^";
   #endif;
   if (total~=MAX_SCORE)
   print "You may want to change MAX_SCORE to ",total,".^";
  #endif;
  if (n>NUMBER_TASKS)
   print_ret "*** WARNING: Too many tasks for task array. ***^Add the line NUMBER_TASKS ",n,
    " (or greater) to your code before including ~Tasks~.";
];

[ achieve t n;
  if (metaclass(t)~=object)
    print_ret "*** Programming Error; achieve called with argument of type ",metaclass(t);
  if(~~(t ofclass ATask))
    print_ret "*** Programming Error; achieve called with non-task object as argument.";  
  n=t.number;
  achieved(n);
];

[ PrintTaskName TaskNumber t;
  objectloop(t in tasks)
    if (t.number==TaskNumber){
       print_ret (name) t;
      
       }
  print_ret "Task name not found";     
];
